/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerAndFloatTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
@GenerateInline
@GenerateCached(value=false)
public abstract class PyTimeFromObjectNode
extends PNodeWithContext {
    public abstract long execute(VirtualFrame var1, Node var2, Object var3, RoundType var4, long var5);

    public final long fromSeconds(VirtualFrame frame, Node inliningTarget, Object obj, RoundType round) {
        return this.execute(frame, inliningTarget, obj, round, 1000000000L);
    }

    @Specialization
    static long doDouble(Node inliningTarget, double d, RoundType round, long unitToNs, @Cached.Shared @Cached PRaiseNode raiseNode) {
        if (Double.isNaN(d)) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_VALUE_NAN);
        }
        double value = d * (double)unitToNs;
        switch (round.ordinal()) {
            case 0: {
                value = Math.floor(value);
                break;
            }
            case 1: {
                value = Math.ceil(value);
                break;
            }
            case 2: 
            case 3: {
                double d2 = value = value >= 0.0 ? Math.ceil(value) : Math.floor(value);
            }
        }
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18) {
            throw PyTimeFromObjectNode.raiseTimeOverflow(inliningTarget, raiseNode);
        }
        return (long)value;
    }

    @Specialization
    static long doLong(Node inliningTarget, long l, RoundType round, long unitToNs, @Cached.Shared @Cached PRaiseNode raiseNode) {
        try {
            return PythonUtils.multiplyExact(l, unitToNs);
        }
        catch (OverflowException e) {
            throw PyTimeFromObjectNode.raiseTimeOverflow(inliningTarget, raiseNode);
        }
    }

    @Specialization
    static long doOther(VirtualFrame frame, Node inliningTarget, Object value, RoundType round, long unitToNs, @Cached CastToJavaDoubleNode castToDouble, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached PyLongAsLongAndOverflowNode asLongNode) {
        try {
            return PyTimeFromObjectNode.doDouble(inliningTarget, castToDouble.execute(inliningTarget, value), round, unitToNs, raiseNode);
        }
        catch (CannotCastException e) {
            try {
                return PyTimeFromObjectNode.doLong(inliningTarget, asLongNode.execute((Frame)frame, inliningTarget, value), round, unitToNs, raiseNode);
            }
            catch (OverflowException e1) {
                throw PyTimeFromObjectNode.raiseTimeOverflow(inliningTarget, raiseNode);
            }
        }
    }

    private static PException raiseTimeOverflow(Node inliningTarget, PRaiseNode raise) {
        throw raise.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.TOO_LARGE_TO_CONVERT_TO, "timestamp", "long");
    }

    public static enum RoundType {
        FLOOR,
        CEILING,
        ROUND_UP,
        TIMEOUT;

    }
}

