/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core.matcher;

import java.awt.Dialog;
import java.util.regex.Pattern;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.matcher.NamedComponentMatcherTemplate;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class DialogMatcher
extends NamedComponentMatcherTemplate<Dialog> {
    private Object title;

    public static DialogMatcher withName(@Nullable String name) {
        return new DialogMatcher(name, DialogMatcher.anyValue());
    }

    @Nonnull
    public static DialogMatcher withTitle(@Nullable String title) {
        return new DialogMatcher(DialogMatcher.anyValue(), (Object)title);
    }

    @Nonnull
    public static DialogMatcher withTitle(@Nonnull Pattern pattern) {
        return new DialogMatcher(DialogMatcher.anyValue(), (Object)pattern);
    }

    @Nonnull
    public static DialogMatcher any() {
        return new DialogMatcher(DialogMatcher.anyValue(), DialogMatcher.anyValue());
    }

    private DialogMatcher(@Nullable Object name, @Nullable Object title) {
        super(Dialog.class, name);
        this.title = title;
    }

    @Nonnull
    public DialogMatcher andTitle(@Nullable String newTitle) {
        this.title = newTitle;
        return this;
    }

    public DialogMatcher andTitle(@Nonnull Pattern titlePattern) {
        this.title = titlePattern;
        return this;
    }

    @Nonnull
    public DialogMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull Dialog dialog) {
        return this.isNameMatching(dialog.getName()) && this.arePropertyValuesMatching(this.title, dialog.getTitle());
    }

    public String toString() {
        String format = "%s[name=%s, title=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.title), this.requireShowing());
    }
}

