/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.actions;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.platform.navbar.frontend.ui.StaticNavBarPanel;
import com.intellij.platform.navbar.frontend.vm.NavBarVm;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class SelectInNavBarTarget
extends SelectInTargetPsiWrapper
implements DumbAware {
    public static final String NAV_BAR_ID = "NavBar";

    SelectInNavBarTarget(@NotNull Project project) {
        if (project == null) {
            SelectInNavBarTarget.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NonNls
    public String getToolWindowId() {
        return NAV_BAR_ID;
    }

    protected boolean canSelect(PsiFileSystemItem file) {
        return UISettings.getInstance().getShowNavigationBar();
    }

    protected void select(Object selector, VirtualFile virtualFile, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar(false);
    }

    protected void select(PsiElement element, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar(false);
    }

    public static void selectInNavBar(boolean showPopup2) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            StaticNavBarPanel navBarPanel;
            NavBarVm vm;
            IdeFrame frame = (IdeFrame)IdeFrame.KEY.getData(context);
            if (frame == null) {
                return;
            }
            StatusBar statusBar = frame.getStatusBar();
            JComponent navBar = null;
            if (statusBar instanceof IdeStatusBarImpl) {
                navBar = ((IdeStatusBarImpl)statusBar).getWidgetComponent(NAV_BAR_ID);
            }
            if (navBar == null && frame instanceof IdeFrameEx) {
                navBar = ((IdeFrameEx)frame).getNorthExtension(NAV_BAR_ID);
            }
            if (navBar == null) {
                return;
            }
            Object panel = navBar.getClientProperty("NavBarPanel");
            if (panel instanceof StaticNavBarPanel && (vm = (navBarPanel = (StaticNavBarPanel)((Object)((Object)panel))).getModel()) != null) {
                vm.selectTail(showPopup2);
            }
        });
    }

    public float getWeight() {
        return 8.0f;
    }

    public String getMinorViewId() {
        return null;
    }

    public String toString() {
        return IdeBundle.message((String)"navigation.bar", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/navbar/frontend/actions/SelectInNavBarTarget", "<init>"));
    }
}

