/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import org.freeplane.core.ui.components.TextIcon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ICombinedCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class DecoratedCondition
extends ASelectableCondition
implements ICombinedCondition {
    protected final ASelectableCondition originalCondition;
    private final String decoratorKey;
    private final String name;

    protected static ASelectableCondition loadOriginalCondition(ConditionFactory conditionFactory, XMLElement element) {
        Vector<XMLElement> children = element.getChildren();
        ASelectableCondition cond = conditionFactory.loadCondition(children.get(0));
        return cond;
    }

    public DecoratedCondition(ASelectableCondition originalCondition, String name, String decoratorKey) {
        this.name = name;
        this.decoratorKey = decoratorKey;
        assert (originalCondition != null);
        this.originalCondition = originalCondition;
    }

    @Override
    protected String createDescription() {
        StringBuilder description = new StringBuilder();
        String decoratorText = TextUtils.getText(this.decoratorKey);
        description.append(decoratorText).append(' ');
        description.append(this.originalCondition.createSmallDescription());
        return description.toString();
    }

    @Override
    protected String getName() {
        return this.name;
    }

    @Override
    public abstract boolean checkNode(NodeModel var1);

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String decoratorText = TextUtils.getText(this.decoratorKey);
        String text = decoratorText + ' ';
        TextIcon decoratorIcon = new TextIcon(text, fontMetrics);
        List<Icon> originalIcons = this.originalCondition.createSmallRendererIcons(fontMetrics);
        ArrayList<Icon> iconList = new ArrayList<Icon>(originalIcons.size() + 1);
        iconList.add(decoratorIcon);
        iconList.addAll(originalIcons);
        return iconList;
    }

    @Override
    public boolean canBePersisted() {
        return this.originalCondition.canBePersisted();
    }

    @Override
    public void fillXML(XMLElement child) {
        this.originalCondition.toXml(child);
    }

    @Override
    public Collection<ASelectableCondition> split() {
        return Arrays.asList(this.originalCondition);
    }

    @Override
    public boolean checksParent() {
        return this.originalCondition.checksParent();
    }

    @Override
    public boolean checksAncestors() {
        return this.originalCondition.checksAncestors();
    }

    @Override
    public boolean checksChildren() {
        return this.originalCondition.checksChildren();
    }

    @Override
    public boolean checksDescendants() {
        return this.originalCondition.checksDescendants();
    }
}

