/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.clipboard;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;

public class MindMapPlainTextWriter {
    public static final MindMapPlainTextWriter INSTANCE = new MindMapPlainTextWriter();

    private MindMapPlainTextWriter() {
    }

    public String getAsPlainText(Collection<NodeModel> selectedNodes, MapClipboardController.CopiedNodeSet copiedNodeSet) {
        try {
            StringWriter stringWriter = new StringWriter();
            try (BufferedWriter fileout = new BufferedWriter(stringWriter);){
                Iterator<NodeModel> it = selectedNodes.iterator();
                while (it.hasNext()) {
                    this.writeTXT(it.next(), copiedNodeSet, fileout, 0);
                }
            }
            return stringWriter.toString();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    private void writeTXT(NodeModel mindMapNodeModel, MapClipboardController.CopiedNodeSet copiedNodeSet, Writer fileout, int depth) throws IOException {
        boolean indentTextOutput = ResourceController.getResourceController().getBooleanProperty("indentTextOutput");
        boolean indentationUsesTabsInTextOutput = ResourceController.getResourceController().getBooleanProperty("indentationUsesTabsInTextOutput");
        String indentation = indentTextOutput ? (indentationUsesTabsInTextOutput ? "\t" : "    ") : "";
        this.writeTXT(mindMapNodeModel, copiedNodeSet, fileout, depth, indentation);
    }

    private void writeTXT(NodeModel node, MapClipboardController.CopiedNodeSet copiedNodeSet, Writer fileout, int depth, String indentation) throws IOException {
        String noteText;
        String detailText;
        String link;
        String core = this.getTransformedTextForClipboard(node, node, node.getUserObject());
        this.writeMultilineTXT(fileout, depth, indentation, core);
        if (NodeLinks.getValidLink(node) != null && !core.contains(link = NodeLinks.getLinkAsString(node))) {
            this.writeTXT(fileout, depth, indentation, " <" + link + ">");
        }
        if ((detailText = DetailModel.getDetailText(node)) != null) {
            String details = this.getTransformedTextForClipboard(node, DetailModel.getDetail(node), detailText);
            this.writeMultilineTXT(fileout, depth + 1, indentation, details);
        }
        if ((noteText = NoteModel.getNoteText(node)) != null) {
            String transformedNote = this.getTransformedTextForClipboard(node, NoteModel.getNote(node), noteText);
            this.writeMultilineTXT(fileout, depth + 1, indentation, transformedNote);
        }
        this.writeChildrenText(node, copiedNodeSet, fileout, depth, indentation);
    }

    private void writeMultilineTXT(Writer fileout, int depth, String indentation, String transformedTextForClipboard) throws IOException {
        String[] plainTextContentStrings;
        for (String plainTextContent : plainTextContentStrings = transformedTextForClipboard.split("\\n")) {
            if (plainTextContent.isEmpty()) continue;
            this.writeTXT(fileout, depth, indentation, plainTextContent);
        }
    }

    private void writeTXT(Writer fileout, int depth, String indentation, String plainTextContent) throws IOException {
        if (!indentation.isEmpty()) {
            for (int i = 0; i < depth; ++i) {
                fileout.write(indentation);
            }
        }
        fileout.write(plainTextContent);
        fileout.write("\n");
    }

    private String getTransformedTextForClipboard(NodeModel node, Object nodeProperty, Object content) {
        String text = TextController.getController().getTransformedTextForClipboard(node, nodeProperty, content);
        String plainTextContent = HtmlUtils.htmlToPlain(text);
        return plainTextContent;
    }

    private void writeChildrenText(NodeModel node, MapClipboardController.CopiedNodeSet copiedNodeSet, Writer fileout, int depth, String indentation) throws IOException {
        for (NodeModel child : node.getChildren()) {
            if (copiedNodeSet == MapClipboardController.CopiedNodeSet.ALL_NODES || child.hasVisibleContent(FilterController.getFilter(node.getMap()))) {
                this.writeTXT(child, copiedNodeSet, fileout, depth + 1, indentation);
                continue;
            }
            this.writeChildrenText(child, copiedNodeSet, fileout, depth, indentation);
        }
    }
}

