/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.infonode.gui.ScrollableBoxListener;
import net.infonode.gui.layout.LayoutUtil;
import net.infonode.gui.panel.SimplePanel;

public class ScrollableBox
extends SimplePanel {
    private LayoutManager l = new LayoutManager(){

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (parent.getComponentCount() > 0) {
                Component panel = parent.getComponent(0);
                panel.setBounds(0, 0, panel.getPreferredSize().width, panel.getPreferredSize().height);
                panel.validate();
                ScrollableBox.this.update();
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension min = parent.getComponentCount() == 0 ? new Dimension(0, 0) : parent.getComponent(0).getMinimumSize();
            return LayoutUtil.add(ScrollableBox.this.vertical ? new Dimension(min.width, 0) : new Dimension(0, min.height), parent.getInsets());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getComponentCount() == 0 ? new Dimension(0, 0) : parent.getComponent(0).getPreferredSize();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    };
    private int leftIndex;
    private boolean vertical;
    private int scrollOffset;
    private boolean leftEnd = true;
    private boolean rightEnd = false;
    private ArrayList layoutOrderList;
    private MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            ScrollableBox.this.setLeftIndex(ScrollableBox.this.leftIndex + e.getWheelRotation());
        }
    };
    private ArrayList listeners = new ArrayList(1);

    public ScrollableBox(final JComponent scrollingContainer, boolean vertical, int scrollOffset) {
        this.setLayout(this.l);
        this.vertical = vertical;
        this.scrollOffset = scrollOffset;
        this.add(scrollingContainer);
        scrollingContainer.addMouseWheelListener(this.mouseWheelListener);
        scrollingContainer.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (scrollingContainer.getParent() != ScrollableBox.this) {
                    scrollingContainer.removeHierarchyListener(this);
                    scrollingContainer.removeMouseWheelListener(ScrollableBox.this.mouseWheelListener);
                }
            }
        });
    }

    public void addScrollableBoxListener(ScrollableBoxListener listener) {
        this.listeners.add(listener);
    }

    public void removeScrollableBoxListener(ScrollableBoxListener listener) {
        this.listeners.remove(listener);
    }

    public void setScrollingContainer(JComponent component) {
    }

    public JComponent getScrollingComponent() {
        return this.getComponentCount() == 0 ? null : (JComponent)this.getComponent(0);
    }

    public void scrollLeft(int numIndex) {
        this.setLeftIndex(this.leftIndex - numIndex);
    }

    public void scrollRight(int numIndex) {
        this.setLeftIndex(this.leftIndex + numIndex);
    }

    public void ensureVisible(int index) {
        int newLeftIndex;
        if (this.leftIndex > index) {
            this.setLeftIndex(index);
        } else if (this.leftIndex < index && (newLeftIndex = this.findFitIndex(index)) > this.leftIndex) {
            this.setLeftIndex(newLeftIndex);
        }
    }

    public boolean isLeftEnd() {
        return this.leftEnd;
    }

    public boolean isRightEnd() {
        return this.rightEnd;
    }

    public void setScrollOffset(int scrollOffset) {
        if (scrollOffset != this.scrollOffset) {
            this.scrollOffset = scrollOffset;
            this.update();
        }
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
        this.update();
        this.fireChanged();
    }

    public void setLayoutOrderList(ArrayList layoutOrderList) {
        this.layoutOrderList = layoutOrderList;
    }

    private int getDimensionSize(Dimension d) {
        return (int)(this.vertical ? d.getHeight() : d.getWidth());
    }

    private Point createPos(int p) {
        return this.vertical ? new Point(0, p) : new Point(p, 0);
    }

    private int getPos(Point p) {
        return this.vertical ? p.y : p.x;
    }

    private int getScrollOffset(int index) {
        if (index == 0) {
            return 0;
        }
        Component c = this.getScrollingComponents()[index - 1];
        return Math.min(this.scrollOffset, Math.max(this.getDimensionSize(c.getMinimumSize()), this.getDimensionSize(c.getPreferredSize()) / 2));
    }

    private Component[] getScrollingComponents() {
        JComponent c = this.getScrollingComponent();
        if (c == null) {
            return new Component[0];
        }
        if (this.layoutOrderList != null) {
            Component[] components = new Component[this.layoutOrderList.size()];
            int i = 0;
            while (i < this.layoutOrderList.size()) {
                components[i] = (Component)this.layoutOrderList.get(i);
                ++i;
            }
            return components;
        }
        return c.getComponents();
    }

    private int getScrollingComponentCount() {
        JComponent c = this.getScrollingComponent();
        return c == null ? 0 : c.getComponentCount();
    }

    private int findFitIndex(int lastIndex) {
        int fitSize = this.getDimensionSize(this.getSize());
        if (fitSize == 0 || lastIndex < 0) {
            return 0;
        }
        Component[] c = this.getScrollingComponents();
        int endPos = this.getPos(c[lastIndex].getLocation()) + this.getDimensionSize(c[lastIndex].getSize());
        int i = lastIndex;
        while (i >= 0) {
            if (endPos - this.getPos(c[i].getLocation()) + this.getScrollOffset(i) > fitSize) {
                return Math.min(c.length - 1, i + 1);
            }
            --i;
        }
        return 0;
    }

    private void update() {
        this.setLeftIndex(this.leftIndex);
    }

    private void setLeftIndex(int index) {
        JComponent scrollingComponent = this.getScrollingComponent();
        int oldLeftIndex = this.leftIndex;
        if (scrollingComponent != null) {
            int count = this.getScrollingComponentCount();
            int fitIndex = this.findFitIndex(count - 1);
            this.leftIndex = Math.min(fitIndex, Math.max(0, index));
            this.leftEnd = this.leftIndex == 0;
            this.rightEnd = this.leftIndex >= fitIndex;
            scrollingComponent.setLocation(this.createPos((count == 0 ? 0 : -this.getPos(this.getScrollingComponents()[this.leftIndex].getLocation())) + this.getScrollOffset(this.leftIndex)));
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                if (oldLeftIndex < index) {
                    this.fireScrolledRight();
                } else if (oldLeftIndex > index) {
                    this.fireScrolledLeft();
                }
                ++i;
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.listeners != null) {
            this.fireChanged();
        }
    }

    private void fireScrolledLeft() {
        Object[] l = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((ScrollableBoxListener)l[i]).scrolledLeft(this);
            ++i;
        }
    }

    private void fireScrolledRight() {
        Object[] l = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((ScrollableBoxListener)l[i]).scrolledRight(this);
            ++i;
        }
    }

    private void fireChanged() {
        Object[] l = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((ScrollableBoxListener)l[i]).changed(this);
            ++i;
        }
    }
}

