/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.mindmapmode;

import com.lightdev.app.shtm.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import org.freeplane.core.util.ColorUtils;

class CharacterColorAction
extends StyledEditorKit.StyledTextAction {
    private static final long serialVersionUID = 1L;
    private final Color darkColor;
    private final Color lightColor;
    private final CSS.Attribute attributeName;

    public CharacterColorAction(String nm, CSS.Attribute attributeName, Color darkColor, Color lightColor) {
        super(nm);
        this.darkColor = darkColor;
        this.lightColor = lightColor;
        this.attributeName = attributeName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JEditorPane editor = this.getEditor(e);
        if (editor != null) {
            Color color = this.getColorCloserTo(editor.getCaretColor());
            if (e != null && e.getSource() == editor) {
                String s = e.getActionCommand();
                try {
                    color = Color.decode(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (color != null) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                String colorRGB = "#" + Integer.toHexString(color.getRGB()).substring(2);
                Util.styleSheet().addCSSAttribute(attr, this.attributeName, colorRGB);
                this.setCharacterAttributes(editor, attr, false);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(editor);
            }
        }
    }

    private Color getColorCloserTo(Color color) {
        if (ColorUtils.isDark((Color)color)) {
            return this.darkColor;
        }
        return this.lightColor;
    }
}

