/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.MediaQuery;
import io.sf.carte.doc.style.css.MediaQueryHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.MediaQueryListListener;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.CSSValueMediaQueryFactory;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQueryImpl;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.NumberValue;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class MediaQueryListImpl
implements MediaQueryList,
MediaListAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedList<MediaQueryImpl> queryList = new LinkedList();
    private LinkedList<CSSParseException> queryErrorList = null;
    boolean invalidQueryList = false;

    MediaQueryListImpl() {
    }

    MediaQueryListImpl(String string) {
        if (string != null && !"all".equalsIgnoreCase(string)) {
            MediaQueryImpl mediaQueryImpl = this.createMediaQuery();
            mediaQueryImpl.setMediaType(string);
            this.queryList.add(mediaQueryImpl);
        }
    }

    protected MediaQueryImpl createMediaQuery() {
        return new MediaQueryImpl(){
            private static final long serialVersionUID = 1L;

            @Override
            protected CSSNumberValue createNumberValue(short s, float f, boolean bl) {
                NumberValue numberValue = NumberValue.createCSSNumberValue(s, f);
                numberValue.setCalculatedNumber(bl);
                return numberValue;
            }
        };
    }

    @Override
    public String getMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.queryList.iterator();
        stringBuilder.append(((MediaQueryImpl)iterator.next()).getMedia());
        while (iterator.hasNext()) {
            stringBuilder.append(',').append(((MediaQueryImpl)iterator.next()).getMedia());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMinifiedMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.queryList.iterator();
        stringBuilder.append(((MediaQueryImpl)iterator.next()).getMinifiedMedia());
        while (iterator.hasNext()) {
            stringBuilder.append(',').append(((MediaQueryImpl)iterator.next()).getMinifiedMedia());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMediaText() {
        return this.getMedia();
    }

    @Override
    public void setMediaText(String string) throws DOMException {
        this.queryList.clear();
        if (!this.parse(string, null)) {
            throw new DOMException(12, "Bad media query: " + string);
        }
    }

    @Override
    public int getLength() {
        int n = this.queryList.size();
        if (n == 0 && this.invalidQueryList) {
            return 1;
        }
        return n;
    }

    @Override
    public String item(int n) {
        int n2 = this.queryList.size();
        if (n2 == 0 && this.invalidQueryList && n == 0) {
            return "not all";
        }
        if (n < 0 || n >= n2) {
            return null;
        }
        return this.queryList.get(n).getMedia();
    }

    @Override
    public MediaQuery getMediaQuery(int n) {
        int n2 = this.queryList.size();
        if (n < 0 || n >= n2 || this.invalidQueryList) {
            return null;
        }
        return this.queryList.get(n);
    }

    @Override
    public MediaQueryList unmodifiable() {
        return new UnmodifiableMediaQueryList();
    }

    @Override
    public void appendMedium(String string) throws DOMException {
        if (!this.parse(string, null)) {
            throw new DOMException(12, "Bad media query: " + string);
        }
    }

    @Override
    public void deleteMedium(String string) throws DOMException {
        throw new DOMException(9, "Delete operation not supported");
    }

    @Override
    public boolean matches(String string, CSSCanvas cSSCanvas) {
        if (this.isAllMedia()) {
            return true;
        }
        for (MediaQueryImpl mediaQueryImpl : this.queryList) {
            if (!mediaQueryImpl.matches(string, cSSCanvas)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MediaQueryList mediaQueryList) {
        MediaQueryListImpl mediaQueryListImpl;
        if (mediaQueryList == null) {
            return !this.isNotAllMedia();
        }
        if (mediaQueryList.isNotAllMedia()) {
            return false;
        }
        if (this.isAllMedia()) {
            return true;
        }
        if (mediaQueryList.isAllMedia()) {
            return false;
        }
        if (mediaQueryList instanceof MediaQueryListImpl) {
            mediaQueryListImpl = (MediaQueryListImpl)mediaQueryList;
        } else if (mediaQueryList.getClass() == UnmodifiableMediaQueryList.class) {
            mediaQueryListImpl = ((UnmodifiableMediaQueryList)mediaQueryList).getEnclosingInstance();
        } else {
            return this.oldMatch(mediaQueryList);
        }
        HashSet<MediaQueryImpl> hashSet = new HashSet<MediaQueryImpl>(mediaQueryListImpl.queryList.size());
        hashSet.addAll(mediaQueryListImpl.queryList);
        for (MediaQueryImpl mediaQueryImpl : this.queryList) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                MediaQueryImpl mediaQueryImpl2 = (MediaQueryImpl)iterator.next();
                if (!mediaQueryImpl.matches(mediaQueryImpl2)) continue;
                iterator.remove();
            }
            if (!hashSet.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean oldMatch(MediaQueryList mediaQueryList) {
        int n;
        int n2 = this.getLength();
        HashSet<String> hashSet = new HashSet<String>(n2);
        for (n = 0; n < n2; ++n) {
            String string = this.item(n).toLowerCase(Locale.ROOT);
            hashSet.add(string);
        }
        n = mediaQueryList.getLength();
        for (int i = 0; i < n; ++i) {
            String string = mediaQueryList.item(i).toLowerCase(Locale.ROOT);
            if (!hashSet.contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllMedia() {
        return this.queryList.isEmpty() && !this.invalidQueryList;
    }

    @Override
    public boolean isNotAllMedia() {
        return this.invalidQueryList || this.queryList.size() == 1 && this.queryList.get(0).isNotAllMedia();
    }

    @Override
    public boolean hasErrors() {
        return this.invalidQueryList || this.queryErrorList != null;
    }

    public LinkedList<CSSParseException> getExceptions() {
        return this.queryErrorList;
    }

    public int hashCode() {
        int n = 1;
        if (this.queryList != null) {
            for (MediaQuery mediaQuery : this.queryList) {
                n += mediaQuery.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        MediaQueryListImpl mediaQueryListImpl;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() == UnmodifiableMediaQueryList.class) {
            mediaQueryListImpl = ((UnmodifiableMediaQueryList)object).getEnclosingInstance();
        } else if (object instanceof MediaQueryListImpl) {
            mediaQueryListImpl = (MediaQueryListImpl)object;
        } else {
            return false;
        }
        return !(this.queryList == null ? mediaQueryListImpl.queryList != null : this.queryList.size() != mediaQueryListImpl.queryList.size() || !this.queryList.containsAll(mediaQueryListImpl.queryList));
    }

    public String toString() {
        return this.getMedia();
    }

    boolean parse(String string, Node node) {
        CSSValueMediaQueryFactory cSSValueMediaQueryFactory = this.getMediaQueryFactory();
        Parser parser = cSSValueMediaQueryFactory.createParser();
        MyMediaQueryHandler myMediaQueryHandler = new MyMediaQueryHandler(node);
        this.invalidQueryList = false;
        parser.parseMediaQueryList(string, cSSValueMediaQueryFactory, myMediaQueryHandler);
        return !this.invalidQueryList;
    }

    protected CSSValueMediaQueryFactory getMediaQueryFactory() {
        return new CSSValueMediaQueryFactory();
    }

    class MyMediaQueryHandler
    implements MediaQueryHandler {
        private MediaQueryImpl currentQuery;
        private boolean invalidQuery = false;
        private boolean compatQuery = false;
        private boolean allMedia = false;
        private final Node ownerNode;

        MyMediaQueryHandler(Node node) {
            this.ownerNode = node;
        }

        @Override
        public void startQuery() {
            this.currentQuery = MediaQueryListImpl.this.createMediaQuery();
        }

        @Override
        public void mediaType(String string) {
            String string2;
            try {
                string2 = ParseHelper.unescapeStringValue(string, false, false);
            }
            catch (DOMNullCharacterException dOMNullCharacterException) {
                string2 = string;
            }
            this.currentQuery.setMediaType(string2);
        }

        @Override
        public void negativeQuery() {
            this.currentQuery.setNegative(true);
        }

        @Override
        public void onlyPrefix() {
            this.currentQuery.setOnlyPrefix(true);
        }

        @Override
        public void condition(BooleanCondition booleanCondition) {
            this.currentQuery.setFeaturePredicate(booleanCondition);
        }

        @Override
        public void endQuery() {
            if (!this.invalidQuery) {
                if (!this.currentQuery.isNotAllMedia() || !this.containsNotAll()) {
                    MediaQueryListImpl.this.queryList.add(this.currentQuery);
                }
                if (MediaQueryListImpl.this.invalidQueryList && !this.compatQuery) {
                    MediaQueryListImpl.this.invalidQueryList = false;
                }
                if (this.currentQuery.isAllMedia()) {
                    this.allMedia = true;
                }
            }
            this.currentQuery = null;
            this.invalidQuery = false;
            this.compatQuery = false;
        }

        private boolean containsNotAll() {
            for (MediaQueryImpl mediaQueryImpl : MediaQueryListImpl.this.queryList) {
                if (!mediaQueryImpl.isNotAllMedia()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endQueryList() {
            if (this.allMedia) {
                MediaQueryListImpl.this.queryList.clear();
            }
        }

        @Override
        public MediaQueryList getMediaQueryList() {
            return MediaQueryListImpl.this;
        }

        @Override
        public boolean reportsErrors() {
            return this.ownerNode != null;
        }

        @Override
        public void invalidQuery(CSSParseException cSSParseException) {
            this.invalidQuery = true;
            MediaQueryListImpl.this.invalidQueryList = true;
            if (MediaQueryListImpl.this.queryErrorList == null) {
                MediaQueryListImpl.this.queryErrorList = new LinkedList();
            }
            MediaQueryListImpl.this.queryErrorList.add(cSSParseException);
            if (this.ownerNode != null) {
                CSSMediaException cSSMediaException = new CSSMediaException(cSSParseException);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryError(this.ownerNode, cSSMediaException);
            }
        }

        @Override
        public void compatQuery(CSSParseException cSSParseException) {
            MediaQueryListImpl.this.invalidQueryList = true;
            this.compatQuery = true;
            if (MediaQueryListImpl.this.queryErrorList == null) {
                MediaQueryListImpl.this.queryErrorList = new LinkedList();
            }
            MediaQueryListImpl.this.queryErrorList.add(cSSParseException);
            if (this.ownerNode != null) {
                CSSMediaException cSSMediaException = new CSSMediaException(cSSParseException);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryWarning(this.ownerNode, cSSMediaException);
            }
        }
    }

    private class UnmodifiableMediaQueryList
    implements MediaQueryList,
    MediaListAccess {
        UnmodifiableMediaQueryList() {
        }

        @Override
        public MediaQuery getMediaQuery(int n) {
            return MediaQueryListImpl.this.getMediaQuery(n);
        }

        @Override
        public String getMedia() {
            return MediaQueryListImpl.this.getMedia();
        }

        @Override
        public String getMinifiedMedia() {
            return MediaQueryListImpl.this.getMinifiedMedia();
        }

        @Override
        public String getMediaText() {
            return this.getMedia();
        }

        @Override
        public int getLength() {
            return MediaQueryListImpl.this.getLength();
        }

        @Override
        public String item(int n) {
            return MediaQueryListImpl.this.item(n);
        }

        @Override
        public boolean isAllMedia() {
            return MediaQueryListImpl.this.isAllMedia();
        }

        @Override
        public boolean isNotAllMedia() {
            return MediaQueryListImpl.this.isNotAllMedia();
        }

        @Override
        public boolean matches(MediaQueryList mediaQueryList) {
            return MediaQueryListImpl.this.matches(mediaQueryList);
        }

        @Override
        public boolean matches(String string, CSSCanvas cSSCanvas) {
            return MediaQueryListImpl.this.matches(string, cSSCanvas);
        }

        @Override
        public MediaQueryList unmodifiable() {
            return this;
        }

        @Override
        public boolean hasErrors() {
            return MediaQueryListImpl.this.hasErrors();
        }

        public LinkedList<CSSParseException> getExceptions() {
            return MediaQueryListImpl.this.getExceptions();
        }

        @Override
        public void addListener(MediaQueryListListener mediaQueryListListener) {
            MediaQueryListImpl.this.addListener(mediaQueryListListener);
        }

        @Override
        public void removeListener(MediaQueryListListener mediaQueryListListener) {
            MediaQueryListImpl.this.removeListener(mediaQueryListListener);
        }

        public int hashCode() {
            return MediaQueryListImpl.this.hashCode();
        }

        public boolean equals(Object object) {
            return MediaQueryListImpl.this.equals(object);
        }

        public String toString() {
            return this.getMedia();
        }

        @Override
        public void setMediaText(String string) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void appendMedium(String string) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void deleteMedium(String string) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        private MediaQueryListImpl getEnclosingInstance() {
            return MediaQueryListImpl.this;
        }
    }
}

